/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.mapping.Property;
import co.elastic.clients.elasticsearch._types.mapping.PropertyVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SemanticTextProperty
implements PropertyVariant,
JsonpSerializable {
    private final Map<String, String> meta;
    private final String inferenceId;
    public static final JsonpDeserializer<SemanticTextProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SemanticTextProperty::setupSemanticTextPropertyDeserializer);

    private SemanticTextProperty(Builder builder) {
        this.meta = ApiTypeHelper.unmodifiable(builder.meta);
        this.inferenceId = ApiTypeHelper.requireNonNull(builder.inferenceId, this, "inferenceId");
    }

    public static SemanticTextProperty of(Function<Builder, ObjectBuilder<SemanticTextProperty>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Property.Kind _propertyKind() {
        return Property.Kind.SemanticText;
    }

    public final Map<String, String> meta() {
        return this.meta;
    }

    public final String inferenceId() {
        return this.inferenceId;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "semantic_text");
        if (ApiTypeHelper.isDefined(this.meta)) {
            generator.writeKey("meta");
            generator.writeStartObject();
            for (Map.Entry<String, String> item0 : this.meta.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.write(item0.getValue());
            }
            generator.writeEnd();
        }
        generator.writeKey("inference_id");
        generator.write(this.inferenceId);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupSemanticTextPropertyDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::meta, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "meta");
        op.add(Builder::inferenceId, JsonpDeserializer.stringDeserializer(), "inference_id");
        op.ignore("type");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<SemanticTextProperty> {
        @Nullable
        private Map<String, String> meta;
        private String inferenceId;

        public final Builder meta(Map<String, String> map) {
            this.meta = Builder._mapPutAll(this.meta, map);
            return this;
        }

        public final Builder meta(String key, String value) {
            this.meta = Builder._mapPut(this.meta, key, value);
            return this;
        }

        public final Builder inferenceId(String value) {
            this.inferenceId = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SemanticTextProperty build() {
            this._checkSingleUse();
            return new SemanticTextProperty(this);
        }
    }
}

