/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.mapping.IndexOptions;
import co.elastic.clients.elasticsearch._types.mapping.Property;
import co.elastic.clients.elasticsearch._types.mapping.PropertyBase;
import co.elastic.clients.elasticsearch._types.mapping.PropertyVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class FlattenedProperty
extends PropertyBase
implements PropertyVariant {
    @Nullable
    private final Double boost;
    @Nullable
    private final Integer depthLimit;
    @Nullable
    private final Boolean docValues;
    @Nullable
    private final Boolean eagerGlobalOrdinals;
    @Nullable
    private final Boolean index;
    @Nullable
    private final IndexOptions indexOptions;
    @Nullable
    private final String nullValue;
    @Nullable
    private final String similarity;
    @Nullable
    private final Boolean splitQueriesOnWhitespace;
    public static final JsonpDeserializer<FlattenedProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FlattenedProperty::setupFlattenedPropertyDeserializer);

    private FlattenedProperty(Builder builder) {
        super(builder);
        this.boost = builder.boost;
        this.depthLimit = builder.depthLimit;
        this.docValues = builder.docValues;
        this.eagerGlobalOrdinals = builder.eagerGlobalOrdinals;
        this.index = builder.index;
        this.indexOptions = builder.indexOptions;
        this.nullValue = builder.nullValue;
        this.similarity = builder.similarity;
        this.splitQueriesOnWhitespace = builder.splitQueriesOnWhitespace;
    }

    public static FlattenedProperty of(Function<Builder, ObjectBuilder<FlattenedProperty>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Property.Kind _propertyKind() {
        return Property.Kind.Flattened;
    }

    @Nullable
    public final Double boost() {
        return this.boost;
    }

    @Nullable
    public final Integer depthLimit() {
        return this.depthLimit;
    }

    @Nullable
    public final Boolean docValues() {
        return this.docValues;
    }

    @Nullable
    public final Boolean eagerGlobalOrdinals() {
        return this.eagerGlobalOrdinals;
    }

    @Nullable
    public final Boolean index() {
        return this.index;
    }

    @Nullable
    public final IndexOptions indexOptions() {
        return this.indexOptions;
    }

    @Nullable
    public final String nullValue() {
        return this.nullValue;
    }

    @Nullable
    public final String similarity() {
        return this.similarity;
    }

    @Nullable
    public final Boolean splitQueriesOnWhitespace() {
        return this.splitQueriesOnWhitespace;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "flattened");
        super.serializeInternal(generator, mapper);
        if (this.boost != null) {
            generator.writeKey("boost");
            generator.write(this.boost.doubleValue());
        }
        if (this.depthLimit != null) {
            generator.writeKey("depth_limit");
            generator.write(this.depthLimit.intValue());
        }
        if (this.docValues != null) {
            generator.writeKey("doc_values");
            generator.write(this.docValues.booleanValue());
        }
        if (this.eagerGlobalOrdinals != null) {
            generator.writeKey("eager_global_ordinals");
            generator.write(this.eagerGlobalOrdinals.booleanValue());
        }
        if (this.index != null) {
            generator.writeKey("index");
            generator.write(this.index.booleanValue());
        }
        if (this.indexOptions != null) {
            generator.writeKey("index_options");
            this.indexOptions.serialize(generator, mapper);
        }
        if (this.nullValue != null) {
            generator.writeKey("null_value");
            generator.write(this.nullValue);
        }
        if (this.similarity != null) {
            generator.writeKey("similarity");
            generator.write(this.similarity);
        }
        if (this.splitQueriesOnWhitespace != null) {
            generator.writeKey("split_queries_on_whitespace");
            generator.write(this.splitQueriesOnWhitespace.booleanValue());
        }
    }

    protected static void setupFlattenedPropertyDeserializer(ObjectDeserializer<Builder> op) {
        PropertyBase.setupPropertyBaseDeserializer(op);
        op.add(Builder::boost, JsonpDeserializer.doubleDeserializer(), "boost");
        op.add(Builder::depthLimit, JsonpDeserializer.integerDeserializer(), "depth_limit");
        op.add(Builder::docValues, JsonpDeserializer.booleanDeserializer(), "doc_values");
        op.add(Builder::eagerGlobalOrdinals, JsonpDeserializer.booleanDeserializer(), "eager_global_ordinals");
        op.add(Builder::index, JsonpDeserializer.booleanDeserializer(), "index");
        op.add(Builder::indexOptions, IndexOptions._DESERIALIZER, "index_options");
        op.add(Builder::nullValue, JsonpDeserializer.stringDeserializer(), "null_value");
        op.add(Builder::similarity, JsonpDeserializer.stringDeserializer(), "similarity");
        op.add(Builder::splitQueriesOnWhitespace, JsonpDeserializer.booleanDeserializer(), "split_queries_on_whitespace");
        op.ignore("type");
    }

    public static class Builder
    extends PropertyBase.AbstractBuilder<Builder>
    implements ObjectBuilder<FlattenedProperty> {
        @Nullable
        private Double boost;
        @Nullable
        private Integer depthLimit;
        @Nullable
        private Boolean docValues;
        @Nullable
        private Boolean eagerGlobalOrdinals;
        @Nullable
        private Boolean index;
        @Nullable
        private IndexOptions indexOptions;
        @Nullable
        private String nullValue;
        @Nullable
        private String similarity;
        @Nullable
        private Boolean splitQueriesOnWhitespace;

        public final Builder boost(@Nullable Double value) {
            this.boost = value;
            return this;
        }

        public final Builder depthLimit(@Nullable Integer value) {
            this.depthLimit = value;
            return this;
        }

        public final Builder docValues(@Nullable Boolean value) {
            this.docValues = value;
            return this;
        }

        public final Builder eagerGlobalOrdinals(@Nullable Boolean value) {
            this.eagerGlobalOrdinals = value;
            return this;
        }

        public final Builder index(@Nullable Boolean value) {
            this.index = value;
            return this;
        }

        public final Builder indexOptions(@Nullable IndexOptions value) {
            this.indexOptions = value;
            return this;
        }

        public final Builder nullValue(@Nullable String value) {
            this.nullValue = value;
            return this;
        }

        public final Builder similarity(@Nullable String value) {
            this.similarity = value;
            return this;
        }

        public final Builder splitQueriesOnWhitespace(@Nullable Boolean value) {
            this.splitQueriesOnWhitespace = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public FlattenedProperty build() {
            this._checkSingleUse();
            return new FlattenedProperty(this);
        }
    }
}

