/*
 * Decompiled with CFR 0.152.
 */
package cn.idev.excel.write.property;

import cn.idev.excel.annotation.write.style.ColumnWidth;
import cn.idev.excel.annotation.write.style.ContentLoopMerge;
import cn.idev.excel.annotation.write.style.ContentRowHeight;
import cn.idev.excel.annotation.write.style.HeadFontStyle;
import cn.idev.excel.annotation.write.style.HeadRowHeight;
import cn.idev.excel.annotation.write.style.HeadStyle;
import cn.idev.excel.annotation.write.style.OnceAbsoluteMerge;
import cn.idev.excel.enums.HeadKindEnum;
import cn.idev.excel.metadata.CellRange;
import cn.idev.excel.metadata.ConfigurationHolder;
import cn.idev.excel.metadata.Head;
import cn.idev.excel.metadata.property.ColumnWidthProperty;
import cn.idev.excel.metadata.property.ExcelHeadProperty;
import cn.idev.excel.metadata.property.FontProperty;
import cn.idev.excel.metadata.property.LoopMergeProperty;
import cn.idev.excel.metadata.property.OnceAbsoluteMergeProperty;
import cn.idev.excel.metadata.property.RowHeightProperty;
import cn.idev.excel.metadata.property.StyleProperty;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ExcelWriteHeadProperty
extends ExcelHeadProperty {
    private RowHeightProperty headRowHeightProperty;
    private RowHeightProperty contentRowHeightProperty;
    private OnceAbsoluteMergeProperty onceAbsoluteMergeProperty;

    public ExcelWriteHeadProperty(ConfigurationHolder configurationHolder, Class<?> headClazz, List<List<String>> head) {
        super(configurationHolder, headClazz, head);
        if (this.getHeadKind() != HeadKindEnum.CLASS) {
            return;
        }
        this.headRowHeightProperty = RowHeightProperty.build(headClazz.getAnnotation(HeadRowHeight.class));
        this.contentRowHeightProperty = RowHeightProperty.build(headClazz.getAnnotation(ContentRowHeight.class));
        this.onceAbsoluteMergeProperty = OnceAbsoluteMergeProperty.build(headClazz.getAnnotation(OnceAbsoluteMerge.class));
        ColumnWidth parentColumnWidth = headClazz.getAnnotation(ColumnWidth.class);
        HeadStyle parentHeadStyle = headClazz.getAnnotation(HeadStyle.class);
        HeadFontStyle parentHeadFontStyle = headClazz.getAnnotation(HeadFontStyle.class);
        for (Map.Entry<Integer, Head> entry : this.getHeadMap().entrySet()) {
            Head headData = entry.getValue();
            if (headData == null) {
                throw new IllegalArgumentException("Passing in the class and list the head, the two must be the same size.");
            }
            Field field = headData.getField();
            ColumnWidth columnWidth = field.getAnnotation(ColumnWidth.class);
            if (columnWidth == null) {
                columnWidth = parentColumnWidth;
            }
            headData.setColumnWidthProperty(ColumnWidthProperty.build(columnWidth));
            HeadStyle headStyle = field.getAnnotation(HeadStyle.class);
            if (headStyle == null) {
                headStyle = parentHeadStyle;
            }
            headData.setHeadStyleProperty(StyleProperty.build(headStyle));
            HeadFontStyle headFontStyle = field.getAnnotation(HeadFontStyle.class);
            if (headFontStyle == null) {
                headFontStyle = parentHeadFontStyle;
            }
            headData.setHeadFontProperty(FontProperty.build(headFontStyle));
            headData.setLoopMergeProperty(LoopMergeProperty.build(field.getAnnotation(ContentLoopMerge.class)));
        }
    }

    public List<CellRange> headCellRangeList() {
        ArrayList<CellRange> cellRangeList = new ArrayList<CellRange>();
        HashSet<String> alreadyRangeSet = new HashSet<String>();
        ArrayList<Head> headList = new ArrayList<Head>(this.getHeadMap().values());
        for (int i = 0; i < headList.size(); ++i) {
            Head head = (Head)headList.get(i);
            List<String> headNameList = head.getHeadNameList();
            for (int j = 0; j < headNameList.size(); ++j) {
                if (alreadyRangeSet.contains(i + "-" + j)) continue;
                alreadyRangeSet.add(i + "-" + j);
                String headName = headNameList.get(j);
                int lastCol = i;
                int lastRow = j;
                int k = i + 1;
                while (k < headList.size()) {
                    String key = k + "-" + j;
                    if (!((Head)headList.get(k)).getHeadNameList().get(j).equals(headName) || alreadyRangeSet.contains(key)) break;
                    alreadyRangeSet.add(key);
                    lastCol = k++;
                }
                HashSet<String> tempAlreadyRangeSet = new HashSet<String>();
                int k2 = j + 1;
                block3: while (k2 < headNameList.size()) {
                    for (int l = i; l <= lastCol; ++l) {
                        String key = l + "-" + k2;
                        if (!((Head)headList.get(l)).getHeadNameList().get(k2).equals(headName) || alreadyRangeSet.contains(key)) break block3;
                        tempAlreadyRangeSet.add(l + "-" + k2);
                    }
                    lastRow = k2++;
                    alreadyRangeSet.addAll(tempAlreadyRangeSet);
                }
                if (j == lastRow && i == lastCol) continue;
                cellRangeList.add(new CellRange(j, lastRow, head.getColumnIndex(), ((Head)headList.get(lastCol)).getColumnIndex()));
            }
        }
        return cellRangeList;
    }

    public RowHeightProperty getHeadRowHeightProperty() {
        return this.headRowHeightProperty;
    }

    public RowHeightProperty getContentRowHeightProperty() {
        return this.contentRowHeightProperty;
    }

    public OnceAbsoluteMergeProperty getOnceAbsoluteMergeProperty() {
        return this.onceAbsoluteMergeProperty;
    }

    public void setHeadRowHeightProperty(RowHeightProperty headRowHeightProperty) {
        this.headRowHeightProperty = headRowHeightProperty;
    }

    public void setContentRowHeightProperty(RowHeightProperty contentRowHeightProperty) {
        this.contentRowHeightProperty = contentRowHeightProperty;
    }

    public void setOnceAbsoluteMergeProperty(OnceAbsoluteMergeProperty onceAbsoluteMergeProperty) {
        this.onceAbsoluteMergeProperty = onceAbsoluteMergeProperty;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExcelWriteHeadProperty)) {
            return false;
        }
        ExcelWriteHeadProperty other = (ExcelWriteHeadProperty)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RowHeightProperty this$headRowHeightProperty = this.getHeadRowHeightProperty();
        RowHeightProperty other$headRowHeightProperty = other.getHeadRowHeightProperty();
        if (this$headRowHeightProperty == null ? other$headRowHeightProperty != null : !this$headRowHeightProperty.equals(other$headRowHeightProperty)) {
            return false;
        }
        RowHeightProperty this$contentRowHeightProperty = this.getContentRowHeightProperty();
        RowHeightProperty other$contentRowHeightProperty = other.getContentRowHeightProperty();
        if (this$contentRowHeightProperty == null ? other$contentRowHeightProperty != null : !this$contentRowHeightProperty.equals(other$contentRowHeightProperty)) {
            return false;
        }
        OnceAbsoluteMergeProperty this$onceAbsoluteMergeProperty = this.getOnceAbsoluteMergeProperty();
        OnceAbsoluteMergeProperty other$onceAbsoluteMergeProperty = other.getOnceAbsoluteMergeProperty();
        return !(this$onceAbsoluteMergeProperty == null ? other$onceAbsoluteMergeProperty != null : !this$onceAbsoluteMergeProperty.equals(other$onceAbsoluteMergeProperty));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ExcelWriteHeadProperty;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        RowHeightProperty $headRowHeightProperty = this.getHeadRowHeightProperty();
        result = result * 59 + ($headRowHeightProperty == null ? 43 : $headRowHeightProperty.hashCode());
        RowHeightProperty $contentRowHeightProperty = this.getContentRowHeightProperty();
        result = result * 59 + ($contentRowHeightProperty == null ? 43 : $contentRowHeightProperty.hashCode());
        OnceAbsoluteMergeProperty $onceAbsoluteMergeProperty = this.getOnceAbsoluteMergeProperty();
        result = result * 59 + ($onceAbsoluteMergeProperty == null ? 43 : $onceAbsoluteMergeProperty.hashCode());
        return result;
    }
}

