/*
 * Decompiled with CFR 0.152.
 */
package cn.idev.excel.write;

import cn.idev.excel.context.WriteContext;
import cn.idev.excel.context.WriteContextImpl;
import cn.idev.excel.enums.WriteTypeEnum;
import cn.idev.excel.exception.ExcelGenerateException;
import cn.idev.excel.support.ExcelTypeEnum;
import cn.idev.excel.util.FileUtils;
import cn.idev.excel.write.ExcelBuilder;
import cn.idev.excel.write.executor.ExcelWriteAddExecutor;
import cn.idev.excel.write.executor.ExcelWriteFillExecutor;
import cn.idev.excel.write.metadata.WriteSheet;
import cn.idev.excel.write.metadata.WriteTable;
import cn.idev.excel.write.metadata.WriteWorkbook;
import cn.idev.excel.write.metadata.fill.FillConfig;
import java.util.Collection;
import org.apache.poi.ss.util.CellRangeAddress;

public class ExcelBuilderImpl
implements ExcelBuilder {
    private final WriteContext context;
    private ExcelWriteFillExecutor excelWriteFillExecutor;
    private ExcelWriteAddExecutor excelWriteAddExecutor;

    public ExcelBuilderImpl(WriteWorkbook writeWorkbook) {
        try {
            this.context = new WriteContextImpl(writeWorkbook);
        }
        catch (RuntimeException e) {
            this.finishOnException();
            throw e;
        }
        catch (Throwable e) {
            this.finishOnException();
            throw new ExcelGenerateException(e);
        }
    }

    @Override
    public void addContent(Collection<?> data, WriteSheet writeSheet) {
        this.addContent(data, writeSheet, null);
    }

    @Override
    public void addContent(Collection<?> data, WriteSheet writeSheet, WriteTable writeTable) {
        try {
            this.context.currentSheet(writeSheet, WriteTypeEnum.ADD);
            this.context.currentTable(writeTable);
            if (this.excelWriteAddExecutor == null) {
                this.excelWriteAddExecutor = new ExcelWriteAddExecutor(this.context);
            }
            this.excelWriteAddExecutor.add(data);
        }
        catch (RuntimeException e) {
            this.finishOnException();
            throw e;
        }
        catch (Throwable e) {
            this.finishOnException();
            throw new ExcelGenerateException(e);
        }
    }

    @Override
    public void fill(Object data, FillConfig fillConfig, WriteSheet writeSheet) {
        try {
            if (this.context.writeWorkbookHolder().getTempTemplateInputStream() == null) {
                throw new ExcelGenerateException("Calling the 'fill' method must use a template.");
            }
            if (this.context.writeWorkbookHolder().getExcelType() == ExcelTypeEnum.CSV) {
                throw new ExcelGenerateException("csv does not support filling data.");
            }
            this.context.currentSheet(writeSheet, WriteTypeEnum.FILL);
            if (this.excelWriteFillExecutor == null) {
                this.excelWriteFillExecutor = new ExcelWriteFillExecutor(this.context);
            }
            this.excelWriteFillExecutor.fill(data, fillConfig);
        }
        catch (RuntimeException e) {
            this.finishOnException();
            throw e;
        }
        catch (Throwable e) {
            this.finishOnException();
            throw new ExcelGenerateException(e);
        }
    }

    private void finishOnException() {
        this.finish(true);
    }

    @Override
    public void finish(boolean onException) {
        if (this.context != null) {
            this.context.finish(onException);
        }
    }

    @Override
    public void merge(int firstRow, int lastRow, int firstCol, int lastCol) {
        CellRangeAddress cra = new CellRangeAddress(firstRow, lastRow, firstCol, lastCol);
        this.context.writeSheetHolder().getSheet().addMergedRegion(cra);
    }

    @Override
    public WriteContext writeContext() {
        return this.context;
    }

    static {
        FileUtils.createPoiFilesDirectory();
    }
}

