/*
 * Decompiled with CFR 0.152.
 */
package cn.idev.excel.analysis.v07.handlers.sax;

import cn.idev.excel.cache.ReadCache;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class SharedStringsTableHandler
extends DefaultHandler {
    private static final Pattern UTF_PATTERN = Pattern.compile("_x([0-9A-Fa-f]{4})_");
    private StringBuilder currentData;
    private StringBuilder currentElementData;
    private final ReadCache readCache;
    private boolean ignoreTagt = false;
    private boolean isTagt = false;

    public SharedStringsTableHandler(ReadCache readCache) {
        this.readCache = readCache;
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) {
        if (name == null) {
            return;
        }
        switch (name) {
            case "t": 
            case "x:t": 
            case "ns2:t": {
                this.currentElementData = null;
                this.isTagt = true;
                break;
            }
            case "si": 
            case "x:si": 
            case "ns2:si": {
                this.currentData = null;
                break;
            }
            case "rPh": 
            case "x:rPh": 
            case "ns2:rPh": {
                this.ignoreTagt = true;
                break;
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) {
        if (name == null) {
            return;
        }
        switch (name) {
            case "t": 
            case "x:t": 
            case "ns2:t": {
                if (this.currentElementData != null) {
                    if (this.currentData == null) {
                        this.currentData = new StringBuilder();
                    }
                    this.currentData.append((CharSequence)this.currentElementData);
                }
                this.isTagt = false;
                break;
            }
            case "si": 
            case "x:si": 
            case "ns2:si": {
                if (this.currentData == null) {
                    this.readCache.put(null);
                    break;
                }
                this.readCache.put(SharedStringsTableHandler.utfDecode(this.currentData.toString()));
                break;
            }
            case "rPh": 
            case "x:rPh": 
            case "ns2:rPh": {
                this.ignoreTagt = false;
                break;
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (!this.isTagt || this.ignoreTagt) {
            return;
        }
        if (this.currentElementData == null) {
            this.currentElementData = new StringBuilder();
        }
        this.currentElementData.append(ch, start, length);
    }

    static String utfDecode(String value) {
        if (value == null || !value.contains("_x")) {
            return value;
        }
        StringBuilder buf = new StringBuilder();
        Matcher m = UTF_PATTERN.matcher(value);
        int idx = 0;
        while (m.find()) {
            int pos = m.start();
            if (pos > idx) {
                buf.append(value, idx, pos);
            }
            String code = m.group(1);
            int icode = Integer.decode("0x" + code);
            buf.append((char)icode);
            idx = m.end();
        }
        if (idx == 0) {
            return value;
        }
        buf.append(value.substring(idx));
        return buf.toString();
    }
}

