/*
 * Decompiled with CFR 0.152.
 */
package cn.idev.excel;

import cn.idev.excel.context.WriteContext;
import cn.idev.excel.write.ExcelBuilder;
import cn.idev.excel.write.ExcelBuilderImpl;
import cn.idev.excel.write.metadata.WriteSheet;
import cn.idev.excel.write.metadata.WriteTable;
import cn.idev.excel.write.metadata.WriteWorkbook;
import cn.idev.excel.write.metadata.fill.FillConfig;
import java.io.Closeable;
import java.util.Collection;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelWriter
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(ExcelWriter.class);
    private final ExcelBuilder excelBuilder;

    public ExcelWriter(WriteWorkbook writeWorkbook) {
        this.excelBuilder = new ExcelBuilderImpl(writeWorkbook);
    }

    public ExcelWriter write(Collection<?> data, WriteSheet writeSheet) {
        return this.write(data, writeSheet, null);
    }

    public ExcelWriter write(Supplier<Collection<?>> supplier, WriteSheet writeSheet) {
        return this.write(supplier.get(), writeSheet, null);
    }

    public ExcelWriter write(Collection<?> data, WriteSheet writeSheet, WriteTable writeTable) {
        this.excelBuilder.addContent(data, writeSheet, writeTable);
        return this;
    }

    public ExcelWriter write(Supplier<Collection<?>> supplier, WriteSheet writeSheet, WriteTable writeTable) {
        this.excelBuilder.addContent(supplier.get(), writeSheet, writeTable);
        return this;
    }

    public ExcelWriter fill(Object data, WriteSheet writeSheet) {
        return this.fill(data, null, writeSheet);
    }

    public ExcelWriter fill(Object data, FillConfig fillConfig, WriteSheet writeSheet) {
        this.excelBuilder.fill(data, fillConfig, writeSheet);
        return this;
    }

    public ExcelWriter fill(Supplier<Object> supplier, WriteSheet writeSheet) {
        return this.fill(supplier.get(), null, writeSheet);
    }

    public ExcelWriter fill(Supplier<Object> supplier, FillConfig fillConfig, WriteSheet writeSheet) {
        this.excelBuilder.fill(supplier.get(), fillConfig, writeSheet);
        return this;
    }

    public void finish() {
        if (this.excelBuilder != null) {
            this.excelBuilder.finish(false);
        }
    }

    public WriteContext writeContext() {
        return this.excelBuilder.writeContext();
    }

    @Override
    public void close() {
        this.finish();
    }

    protected void finalize() {
        try {
            this.finish();
        }
        catch (Throwable e) {
            log.warn("Destroy object failed", e);
        }
    }
}

