/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.http;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.ContentType;
import cn.hutool.http.Header;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum GlobalHeaders {
    INSTANCE;

    protected Map<String, List<String>> headers = new HashMap<String, List<String>>();

    private GlobalHeaders() {
        this.putDefault(false);
    }

    public GlobalHeaders putDefault(boolean isReset) {
        if (isReset) {
            this.headers.clear();
        }
        this.header(Header.ACCEPT, "text/html,application/xhtml+xml,application/xml,application/json;q=0.9,*/*;q=0.8", true);
        this.header(Header.ACCEPT_ENCODING, "gzip", true);
        this.header(Header.ACCEPT_LANGUAGE, "zh-CN,zh;q=0.8", true);
        this.header(Header.CONTENT_TYPE, ContentType.FORM_URLENCODED.toString(CharsetUtil.CHARSET_UTF_8), true);
        this.header(Header.USER_AGENT, "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.84 Safari/537.36 Hutool", true);
        return this;
    }

    public String header(String name) {
        List<String> values = this.headerList(name);
        if (CollectionUtil.isEmpty(values)) {
            return null;
        }
        return values.get(0);
    }

    public List<String> headerList(String name) {
        if (StrUtil.isBlank(name)) {
            return null;
        }
        return this.headers.get(name.trim());
    }

    public String header(Header name) {
        if (null == name) {
            return null;
        }
        return this.header(name.toString());
    }

    public GlobalHeaders header(String name, String value, boolean isOverride) {
        if (null != name && null != value) {
            List<String> values = this.headers.get(name.trim());
            if (isOverride || CollectionUtil.isEmpty(values)) {
                ArrayList<String> valueList = new ArrayList<String>();
                valueList.add(value);
                this.headers.put(name.trim(), valueList);
            } else {
                values.add(value.trim());
            }
        }
        return this;
    }

    public GlobalHeaders header(Header name, String value, boolean isOverride) {
        return this.header(name.toString(), value, isOverride);
    }

    public GlobalHeaders header(Header name, String value) {
        return this.header(name.toString(), value, true);
    }

    public GlobalHeaders header(String name, String value) {
        return this.header(name, value, true);
    }

    public GlobalHeaders header(Map<String, List<String>> headers) {
        if (CollectionUtil.isEmpty(headers)) {
            return this;
        }
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            String name = entry.getKey();
            for (String value : entry.getValue()) {
                this.header(name, StrUtil.nullToEmpty(value), false);
            }
        }
        return this;
    }

    public GlobalHeaders removeHeader(String name) {
        if (name != null) {
            this.headers.remove(name.trim());
        }
        return this;
    }

    public GlobalHeaders removeHeader(Header name) {
        return this.removeHeader(name.toString());
    }

    public Map<String, List<String>> headers() {
        return Collections.unmodifiableMap(this.headers);
    }
}

